/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rbf.impl;

import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.rbf.RbfException;
import com.ibm.hwmca.fw.rbf.RbfRequest;
import com.ibm.hwmca.fw.rbf.RbfRequestId;
import com.ibm.hwmca.fw.rbf.impl.CommManager;
import com.ibm.hwmca.fw.rbf.impl.CompleteMsg;
import com.ibm.hwmca.fw.rbf.impl.HandlerPreparer;
import com.ibm.hwmca.fw.rbf.impl.QueryMsg;
import com.ibm.hwmca.fw.rbf.impl.QueryReply;
import com.ibm.hwmca.fw.rbf.impl.RbfReply;
import com.ibm.hwmca.fw.rbf.impl.RbfUtils;
import com.ibm.hwmca.fw.rbf.impl.RequestTrackingData;
import com.ibm.hwmca.fw.util.NamedTimer;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

class QueryTask
extends TimerTask {
    private static final String TRACE_MASKT = "XRBFQTST";
    private static final String TRACE_MASKF = "XRBFQTSF";
    private static final String TRACE_MASKD = "XRBFQTSD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "RBF-QueryTsk");
    private static Timer queryTimer = new NamedTimer(true, "RBF Query Task Timer");
    static final long RUN_INTERVAL = 300000L;
    private static final int QUERY_MSG_TIMEOUT = 180000;
    private RbfRequestId requestId;

    QueryTask(RbfRequestId requestId) {
        this.requestId = requestId;
        Trace.trace(TRACE_MASKT, "<> QueryTask() " + requestId);
    }

    static Timer getTimer() {
        return queryTimer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Trace.trace(TRACE_MASKT, "-> Query task running " + this.requestId);
        RbfRequest request = RbfRequest.getRequest(this.requestId);
        if (request == null) {
            Trace.trace(TRACE_MASKF, "Request no longer managed");
            this.cancel();
            Trace.trace(TRACE_MASKT, "<- Query task ending " + this.requestId);
            return;
        }
        Trace.trace(TRACE_MASKF, "Querying: " + request.toDebugString());
        RequestTrackingData trackingData = request.getTrackingData();
        QueryMsg queryMsg = null;
        HashSet<MachineId> queried = new HashSet<MachineId>();
        boolean finished = false;
        while (!finished) {
            MachineId nextTarget = null;
            CriticalData savedCritData = null;
            RequestTrackingData requestTrackingData = trackingData;
            synchronized (requestTrackingData) {
                if (trackingData.state == 4 || trackingData.state == 8) {
                    nextTarget = this.getNextTarget(trackingData, queried);
                    if (nextTarget != null) {
                        savedCritData = new CriticalData(trackingData);
                        if (queryMsg == null) {
                            queryMsg = new QueryMsg(this.requestId);
                        }
                    } else {
                        Trace.trace(TRACE_MASKF, "No machines remaining to query");
                        if (trackingData.isHandlerNeeded()) {
                            HandlerPreparer.prepareHandlers(request);
                        }
                        finished = true;
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "Request no longer requires query");
                    this.cancel();
                    finished = true;
                }
            }
            if (finished) continue;
            QueryReply queryReply = this.sendQueryMsg(queryMsg, nextTarget, request);
            RequestTrackingData requestTrackingData2 = trackingData;
            synchronized (requestTrackingData2) {
                if (trackingData.state == 4 || trackingData.state == 8) {
                    CriticalData currentCritData = new CriticalData(trackingData);
                    if (currentCritData.equals(savedCritData)) {
                        queried.add(nextTarget);
                        this.processQueryReply(nextTarget, queryReply, request);
                    } else {
                        Trace.trace(TRACE_MASKF, "Tracking data update voids query");
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "Request no longer requires query");
                    this.cancel();
                    finished = true;
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- Query task ending " + this.requestId);
    }

    private MachineId getNextTarget(RequestTrackingData trackingData, Set excluded) {
        ArrayList<MachineId> targets = new ArrayList<MachineId>();
        boolean handlerNeeded = trackingData.isHandlerNeeded();
        if (trackingData.state == 4) {
            if (handlerNeeded) {
                if (trackingData.preparing != null) {
                    targets.addAll(trackingData.preparing);
                }
                if (trackingData.aborting != null) {
                    targets.addAll(trackingData.aborting);
                }
            }
        } else if (trackingData.state == 8) {
            if (handlerNeeded) {
                if (trackingData.preparing != null) {
                    targets.addAll(trackingData.preparing);
                }
                if (trackingData.aborting != null) {
                    targets.addAll(trackingData.aborting);
                }
            } else if (trackingData.handler != null) {
                targets.add(trackingData.handler);
            }
        }
        if (trackingData.unusable != null) {
            targets.removeAll(trackingData.unusable);
        }
        if (excluded != null) {
            targets.removeAll(excluded);
        }
        if (!targets.isEmpty()) {
            return (MachineId)targets.get(targets.size() - 1);
        }
        return null;
    }

    private QueryReply sendQueryMsg(QueryMsg msg, MachineId target, RbfRequest request) {
        try {
            CommManager commMgr = CommManager.getCommManager();
            RbfReply reply = commMgr.send(msg, target, 180000);
            if (reply instanceof QueryReply) {
                return (QueryReply)reply;
            }
            String desc = "Internal error: Invalid query reply (" + reply.getClass().getName() + ") received from " + RbfUtils.getMachineInfo(target) + " " + request.getIdentifier();
            Trace.trace(TRACE_MASKF, desc);
            FrameworkLog fl = new FrameworkLog(classLogInfo, 1060);
            fl.add(desc);
            fl.add(RbfUtils.getLoggingInfo(request));
            fl.log();
            return null;
        }
        catch (RbfException rbfe) {
            return null;
        }
    }

    private void processQueryReply(MachineId target, QueryReply queryReply, RbfRequest request) {
        RequestTrackingData trackingData = request.getTrackingData();
        boolean handlerNeeded = trackingData.isHandlerNeeded();
        if (queryReply == null || !queryReply.isValidStatus(queryReply.getStatus())) {
            if (queryReply != null) {
                String desc = "Internal error: Invalid query reply status (" + queryReply.getStatus() + ") received from " + RbfUtils.getMachineInfo(target) + this.requestId;
                Trace.trace(TRACE_MASKF, desc);
                FrameworkLog fl = new FrameworkLog(classLogInfo, 1060);
                fl.add(desc);
                fl.add(RbfUtils.getLoggingInfo(request));
                fl.log();
            }
            if (trackingData.state == 4) {
                if (handlerNeeded) {
                    trackingData.removePreparing(target);
                    trackingData.removeAborting(target);
                } else if (target.equals(trackingData.handler)) {
                    trackingData.handlerOutage = true;
                }
            } else if (trackingData.state == 8) {
                if (handlerNeeded) {
                    trackingData.removePreparing(target);
                    trackingData.removeAborting(target);
                } else if (target.equals(trackingData.handler)) {
                    trackingData.handlerOutage = true;
                }
            }
            trackingData.addUnusable(target);
        } else if (queryReply.getStatus() == 16) {
            if (trackingData.state == 4) {
                if (handlerNeeded) {
                    trackingData.removePreparing(target);
                    trackingData.removeAborting(target);
                } else if (target.equals(trackingData.handler)) {
                    trackingData.handlerOutage = true;
                }
            } else if (trackingData.state == 8) {
                if (handlerNeeded) {
                    trackingData.removePreparing(target);
                    trackingData.removeAborting(target);
                } else if (target.equals(trackingData.handler)) {
                    byte[] responseEncoding = queryReply.getResponseEncoding();
                    if (responseEncoding != null) {
                        CompleteMsg completeMsg = new CompleteMsg(request, responseEncoding);
                        completeMsg.process(target, 2);
                    } else {
                        trackingData.handlerOutage = true;
                    }
                }
            }
            trackingData.addUnusable(target);
        }
    }

    private static class CriticalData {
        Set aborting = null;
        Set preparing = null;
        Set unusable = null;
        MachineId handler = null;

        CriticalData(RequestTrackingData trackingData) {
            if (trackingData.aborting != null) {
                this.aborting = new HashSet(trackingData.aborting);
            }
            if (trackingData.preparing != null) {
                this.preparing = new HashSet(trackingData.preparing);
            }
            if (trackingData.unusable != null) {
                this.unusable = new HashSet(trackingData.unusable);
            }
            this.handler = trackingData.handler;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CriticalData)) {
                return false;
            }
            CriticalData critData = (CriticalData)obj;
            if (this.aborting != null ? !((Object)this.aborting).equals(critData.aborting) : critData.aborting != null) {
                return false;
            }
            if (this.preparing != null ? !((Object)this.preparing).equals(critData.preparing) : critData.preparing != null) {
                return false;
            }
            if (this.unusable != null ? !((Object)this.unusable).equals(critData.unusable) : critData.unusable != null) {
                return false;
            }
            return !(this.handler != null ? !this.handler.equals(critData.handler) : critData.handler != null);
        }

        public int hashCode() {
            throw new UnsupportedOperationException();
        }
    }
}

